/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import scala.tools.asm.Label;
import scala.tools.asm.MethodVisitor;
import scala.tools.asm.tree.AbstractInsnNode;
import scala.tools.asm.tree.LabelNode;

public class TableSwitchInsnNode
extends AbstractInsnNode {
    public int min;
    public int max;
    public LabelNode dflt;
    public List<LabelNode> labels;

    public TableSwitchInsnNode(int min2, int max2, LabelNode dflt, LabelNode ... labels2) {
        super(170);
        this.min = min2;
        this.max = max2;
        this.dflt = dflt;
        this.labels = new ArrayList<LabelNode>();
        if (labels2 != null) {
            this.labels.addAll(Arrays.asList(labels2));
        }
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public void accept(MethodVisitor mv) {
        Label[] labels2 = new Label[this.labels.size()];
        for (int i = 0; i < labels2.length; ++i) {
            labels2[i] = this.labels.get(i).getLabel();
        }
        mv.visitTableSwitchInsn(this.min, this.max, this.dflt.getLabel(), labels2);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> labels2) {
        return new TableSwitchInsnNode(this.min, this.max, TableSwitchInsnNode.clone(this.dflt, labels2), TableSwitchInsnNode.clone(this.labels, labels2));
    }
}

